#version 430

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec3 texCoords;

layout (location = 3) in ivec4 firstBoneIDs;
layout (location = 4) in vec4 firstBoneWeights;

layout (location = 0) out vec3 fragPos;
layout (location = 2) out vec3 fragTexCoords;

uniform mat4 projection;
uniform mat4 view;

uniform int BoneCount;

uniform samplerBuffer tbo;


mat4 getBone(int boneID){

	mat4 newMat;

		newMat[0] = texelFetch(tbo, 4 + int(4 * boneID));
		newMat[1] = texelFetch(tbo, 5 + int(4 * boneID));
		newMat[2] = texelFetch(tbo, 6 + int(4 * boneID));
		newMat[3] = texelFetch(tbo, 7 + int(4 * boneID));

	return newMat;

}


void main()

{
	
	mat4 model;

	// get the model matrix
	model[0] = texelFetch(tbo, 0);
	model[1] = texelFetch(tbo, 1);
	model[2] = texelFetch(tbo, 2);
	model[3] = texelFetch(tbo, 3);


	mat4 transformMatrix = mat4(1.0);
	
	if (BoneCount > 0){
	
	transformMatrix = firstBoneWeights.x * getBone(firstBoneIDs.x);
	transformMatrix += firstBoneWeights.y * getBone(firstBoneIDs.y);
	transformMatrix += firstBoneWeights.z * getBone(firstBoneIDs.z);
	transformMatrix += firstBoneWeights.w * getBone(firstBoneIDs.w);

	}
	

	vec4 viewPos = model * transformMatrix * vec4(position, 1.0f);
	
	gl_Position = projection * view * viewPos;

	fragTexCoords = texCoords;

	fragPos.xyz = viewPos.xyz;

}